# Ejecutar como administrador

# 1. Configurar directivas locales
Write-Host "Configurando directivas locales..."

# Modelo de seguridad clásico
secedit /export /cfg C:\secpol.cfg
(Get-Content C:\secpol.cfg).Replace("SeNetworkLogonRight = ", "SeNetworkLogonRight = *S-1-5-11") | Set-Content C:\secpol.cfg
secedit /configure /db secedit.sdb /cfg C:\secpol.cfg /areas SECURITYPOLICY

# Permitir grupo Todos como anónimo
reg add "HKLM\SYSTEM\CurrentControlSet\Control\Lsa" /v "EveryoneIncludesAnonymous" /t REG_DWORD /d 1 /f

# Deshabilitar restricción SAM
reg add "HKLM\SYSTEM\CurrentControlSet\Control\Lsa" /v "RestrictAnonymousSAM" /t REG_DWORD /d 0 /f

# 2. Permitir acceso SMB de invitado
Write-Host "Habilitando acceso SMB de invitado..."
reg add "HKLM\SYSTEM\CurrentControlSet\Services\LanmanWorkstation\Parameters" /v "AllowInsecureGuestAuth" /t REG_DWORD /d 1 /f

# 3. Desactivar protección con contraseña en uso compartido
Write-Host "Desactivando protección con contraseña..."
$sharingKey = "HKLM\SYSTEM\CurrentControlSet\Services\Netlogon\Parameters"
reg add $sharingKey /v "DisablePasswordChange" /t REG_DWORD /d 1 /f

# 4. Reiniciar servicios relevantes
Write-Host "Reiniciando servicios..."
Restart-Service lanmanserver
Restart-Service lanmanworkstation

Write-Host "✅ Configuración completada. Reinicia el equipo para aplicar todos los cambios."

# Ejecutar este script como Administrador
# Guardar como: Enable-GuestShare.ps1

Write-Host "=== Configuración de acceso sin credenciales en Windows 11 LTSC 2025 ==="

# 1. Habilitar cuenta Invitado y quitar contraseña
Write-Host "Habilitando cuenta Invitado..."
net user guest /active:yes
net user guest ""

# 2. Ajustar políticas LSA para permitir acceso anónimo
Write-Host "Modificando claves LSA..."
reg add "HKLM\SYSTEM\CurrentControlSet\Control\Lsa" /v "EveryoneIncludesAnonymous" /t REG_DWORD /d 1 /f
reg add "HKLM\SYSTEM\CurrentControlSet\Control\Lsa" /v "RestrictAnonymous" /t REG_DWORD /d 0 /f
reg add "HKLM\SYSTEM\CurrentControlSet\Control\Lsa" /v "RestrictAnonymousSAM" /t REG_DWORD /d 0 /f

# 3. Permitir SMB invitado inseguro
Write-Host "Habilitando SMB invitado inseguro..."
reg add "HKLM\SYSTEM\CurrentControlSet\Services\LanmanWorkstation\Parameters" /v "AllowInsecureGuestAuth" /t REG_DWORD /d 1 /f

# 4. Desactivar protección con contraseña en uso compartido
Write-Host "Desactivando protección con contraseña en uso compartido..."
reg add "HKLM\SYSTEM\CurrentControlSet\Services\Netlogon\Parameters" /v "DisablePasswordChange" /t REG_DWORD /d 1 /f

# 5. Reiniciar servicios de red
Write-Host "Reiniciando servicios de red..."
Restart-Service lanmanserver -Force
Restart-Service lanmanworkstation -Force

Write-Host "✅ Configuración aplicada. Reinicia el equipo para asegurar que todos los cambios tengan efecto."